/*
 * @(#)ObjectModelFactory.java  1.0  February 17, 2004
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.oo;

import ch.hslu.cm.oo.diagram.OMAssociationFigure;
import ch.hslu.cm.oo.diagram.OMBidirectionalLinkFigure;
import ch.hslu.cm.oo.diagram.OMCommentLinkFigure;
import ch.hslu.cm.oo.diagram.OMDependencyFigure;
import ch.hslu.cm.oo.diagram.OMGeneralizationFigure;
import ch.hslu.cm.oo.diagram.OMMethodFigure;
import ch.hslu.cm.oo.diagrambsh.ClassFigureBsh;
import ch.hslu.cm.oo.diagrambsh.DraggableMessageFigureBsh;
import ch.hslu.cm.oo.diagrambsh.ObjectFigureBsh;
import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.oo.objectmodelbsh.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * ObjectModelFactory.
 *
 * @author  Werner Randelshofer
 * @version 1.0 February 17, 2004 Created.
 */
public class OMBshFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        { ObjectModelBsh.class, "objectmodel" },
        { OMAssociation.class, "association" },
        { OMAttribute.class, "attribute" },
        { OMDependency.class, "dependency" },
        { OMGeneralization.class, "generalization" },
        { OMBidirectionalLink.class, "link" },
        { OMOperation.class, "operation" },
        { OMBshClass.class, "class" },
        { OMBshObject.class, "object" },

        { ClassDiagram.class, "classdiagram" },
        { OMAssociationFigure.class, "associationF" },
        { ClassFigureBsh.class, "classF" },
        { OMDependencyFigure.class, "dependencyF" },
        { OMGeneralizationFigure.class, "generalizationF" },
        { OMBidirectionalLinkFigure.class, "linkF" },
        { ObjectFigureBsh.class, "objectF" },
        { TextFigure.class, "textF" },
        { OMMethodFigure.class, "methodF" },
        { OMCommentLinkFigure.class, "commentLinkF" },
        { GroupFigure.class, "g" },
        { DraggableMessageFigureBsh.class, "dragmsg" },
        { TextAreaFigure.class, "ta" },
        
        { StickyRectangleConnector.class, "arectConnector" },
        { ChopRectangleConnector.class, "rectConnector" },
        { BezierLabelLocator.class, "polylabelLocator" },
        { ArrowTip.class, "arrowTip" }
    };
    private final static Object[][] enumTagArray = {
        { AttributeKeys.StrokePlacement.class, "strokePlacement" },
        { AttributeKeys.StrokeType.class, "strokeType" },
        { AttributeKeys.Underfill.class, "underfill" },
    };
    
    
    /** Creates a new instance. */
    public OMBshFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
        for (Object[] o : enumTagArray) {
            addEnumClass((String) o[1], (Class) o[0]);
        }
    }
}
